/*!\file DatasetInput.c
 * \brief: implementation of the datasetinput object
 */
/*Headers{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DatasetInput constructors and destructor*/
/*FUNCTION DatasetInput::DatasetInput(){{{1*/
DatasetInput::DatasetInput(){
	enum_type=UNDEF;
	inputs=NULL;
}
/*}}}*/
/*FUNCTION DatasetInput::DatasetInput(int in_enum_type) {{{1*/
DatasetInput::DatasetInput(int in_enum_type){

	enum_type  = in_enum_type;
	inputs     = new Inputs();
}
/*}}}*/
/*FUNCTION DatasetInput::~DatasetInput(){{{1*/
DatasetInput::~DatasetInput(){
	delete inputs;
}
/*}}}*/

/*Object virtual functions definitions:*/
		/*FUNCTION DatasetInput::Echo {{{1*/
void DatasetInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DatasetInput::DeepEcho{{{1*/
void DatasetInput::DeepEcho(void){

	printf("DatasetInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("---inputs: \n"); inputs->Echo();
}
/*}}}*/
/*FUNCTION DatasetInput::Id{{{1*/
int    DatasetInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DatasetInput::MyRank{{{1*/
int    DatasetInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION DatasetInput::Marshall{{{1*/
void  DatasetInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	char* marshalled_inputs=NULL;
	int   marshalled_inputs_size;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DatasetInput: */
	enum_value=DatasetInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall enum_type: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	/*marshal inputs*/
	marshalled_inputs_size=inputs->MarshallSize();
	marshalled_inputs=inputs->Marshall();
	memcpy(marshalled_dataset,marshalled_inputs,marshalled_inputs_size*sizeof(char));
	marshalled_dataset+=marshalled_inputs_size;

	/*clean up and assign output pointer*/
	xfree((void**)&marshalled_inputs);
	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DatasetInput::MarshallSize{{{1*/
int   DatasetInput::MarshallSize(){
	
	int size=0;

	size=sizeof(enum_type)+
	  +inputs->MarshallSize()
	  +sizeof(int); //sizeof(int) for enum value

	return size;
}
/*}}}*/
/*FUNCTION DatasetInput::Demarshall{{{1*/
void  DatasetInput::Demarshall(char** pmarshalled_dataset){
	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	/*Demarshal values*/
	inputs=(Inputs*)DataSetDemarshallRaw(&marshalled_dataset); 

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION DatasetInput::ObjectEnum{{{1*/
int DatasetInput::ObjectEnum(void){

	return DatasetInputEnum;

}
/*}}}*/
/*FUNCTION DatasetInput::copy{{{1*/
Object* DatasetInput::copy() {
	
	DatasetInput* output=NULL;

	output = new DatasetInput();
	output->enum_type=this->enum_type;
	output->inputs=(Inputs*)this->inputs->Copy();

	return output;
}
/*}}}*/
/*FUNCTION DatasetInput::SpawnTriaInput{{{1*/
Input* DatasetInput::SpawnTriaInput(int* indices){

	/*output*/
	DatasetInput* outinput=NULL;

	/*Create new Datasetinput (copy of current input)*/
	outinput=new DatasetInput();
	outinput->enum_type=this->enum_type;
	outinput->inputs=(Inputs*)this->inputs->SpawnTriaInputs(indices);

	/*Assign output*/
	return outinput;
}
/*}}}*/
	
/*DatasetInput management*/
/*FUNCTION DatasetInput::InstanceEnum{{{1*/
int DatasetInput::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/

/*Object functions*/
/*FUNCTION DatasetInput::Configure{{{1*/
void DatasetInput::Configure(Parameters* parameters){
	/*do nothing: */
}
/*}}}*/
/*FUNCTION DatasetInput::GetParameterValue(double* pvalue,GaussTria* gauss,int index){{{1*/
void DatasetInput::GetParameterValue(double* pvalue,GaussTria* gauss,int index){

	/*Get requested input within dataset*/
	if(index<0 || index > inputs->Size()-1) _error_("index requested (%i) exceeds dataset size (%i)",index,inputs->Size());
	Input* input=(Input*)this->inputs->GetObjectByOffset(index);
	
	input->GetParameterValue(pvalue,gauss);
}
/*}}}*/
