/*!\file StringParam.c
 * \brief: implementation of the StringParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*StringParam constructors and destructor*/
/*FUNCTION StringParam::StringParam(){{{1*/
StringParam::StringParam(){
	return;
}
/*}}}*/
/*FUNCTION StringParam::StringParam(int enum_type,IssmString value){{{1*/
StringParam::StringParam(int in_enum_type,char* in_value){

	enum_type=in_enum_type;
	value=(char*)xmalloc((strlen(in_value)+1)*sizeof(char));
	memcpy(value,in_value,(strlen(in_value)+1)*sizeof(char));

	
}
/*}}}*/
/*FUNCTION StringParam::~StringParam(){{{1*/
StringParam::~StringParam(){
	xfree((void**)&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION StringParam::Echo {{{1*/
void StringParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringParam::DeepEcho{{{1*/
void StringParam::DeepEcho(void){
	printf("StringParam:\n");
	printf("   enum:  %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %s\n",this->value);
}
/*}}}*/
/*FUNCTION StringParam::Id{{{1*/
int    StringParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringParam::MyRank{{{1*/
int    StringParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION StringParam::Marshall{{{1*/
void  StringParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;
	int   stringsize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of StringParam: */
	enum_value=StringParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);

	/*marshall data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	stringsize=strlen(this->value)+1;
	
	memcpy(marshalled_dataset,&stringsize,sizeof(stringsize));marshalled_dataset+=sizeof(stringsize);
	memcpy(marshalled_dataset,this->value,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION StringParam::MarshallSize{{{1*/
int   StringParam::MarshallSize(){

	int stringsize;
	stringsize=strlen(this->value)+1;
	
	return sizeof(int)+
		stringsize*sizeof(char)+
		sizeof(enum_type)+
		sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION StringParam::Demarshall{{{1*/
void  StringParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;
	int   stringsize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	memcpy(&stringsize,marshalled_dataset,sizeof(int));marshalled_dataset+=sizeof(int);
	
	this->value=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(this->value,marshalled_dataset,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION StringParam::ObjectEnum{{{1*/
int StringParam::ObjectEnum(void){

	return StringParamEnum;

}
/*}}}*/
/*FUNCTION StringParam::copy{{{1*/
Object* StringParam::copy() {
	
	return new StringParam(this->enum_type,this->value);

}
/*}}}*/

/*StringParam virtual functions definitions: */
/*FUNCTION StringParam::GetParameterValue{{{1*/
void  StringParam::GetParameterValue(char** pstring){
	
	char* outstring=NULL;
	int   stringsize;

	stringsize=strlen(this->value)+1;

	outstring=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(outstring,this->value,stringsize*sizeof(char));

	*pstring=outstring;

}
/*}}}*/
/*FUNCTION StringParam::GetParameterName{{{1*/
char* StringParam::GetParameterName(void){
	return  EnumToStringx(this->enum_type);
}
/*}}}*/
/*FUNCTION StringParam::SetMatlabField{{{1*/
#ifdef _SERIAL_
void  StringParam::SetMatlabField(mxArray* dataref){
	
	char* name=NULL;

	name=this->GetParameterName();
	mxSetField( dataref, 0, name, mxCreateString(value));
}
#endif
/*}}}*/
/*FUNCTION StringParam::SetValue{{{1*/
void  StringParam::SetValue(char* string){
	
	int   stringsize;
	
	/*avoid leak: */
	xfree((void**)&this->value);

	/*copy: */
	stringsize=strlen(string)+1;
	this->value=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(this->value,string,stringsize*sizeof(char));

}
/*}}}*/
/*FUNCTION StringParam::UnitConversion{{{1*/
void  StringParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
