/*!\file StringArrayParam.c
 * \brief: implementation of the StringArrayParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*StringArrayParam constructors and destructor*/
/*FUNCTION StringArrayParam::StringArrayParam(){{{1*/
StringArrayParam::StringArrayParam(){
	return;
}
/*}}}*/
/*FUNCTION StringArrayParam::StringArrayParam(int enum_type,char** in_values,int in_numstrings){{{1*/
StringArrayParam::StringArrayParam(int in_enum_type,char** in_values, int in_numstrings){

	int i;
	int size;

	enum_type=in_enum_type;
	numstrings=in_numstrings;

	if(numstrings){
		value=(char**)xmalloc(numstrings*sizeof(char*));
		for(i=0;i<numstrings;i++){
			char* string=NULL;
			size=strlen(in_values[i])+1;
			string=(char*)xmalloc(size*sizeof(char));
			memcpy(string,in_values[i],size*sizeof(char));
			value[i]=string;
		}
	}
	else value=NULL;
	
}
/*}}}*/
/*FUNCTION StringArrayParam::~StringArrayParam(){{{1*/
StringArrayParam::~StringArrayParam(){
		
	int i;
	
	char* string=NULL;
	for(i=0;i<this->numstrings;i++){
		string=value[i];
		xfree((void**)&string);
	}
	xfree((void**)&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION StringArrayParam::Echo {{{1*/
void StringArrayParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringArrayParam::DeepEcho{{{1*/
void StringArrayParam::DeepEcho(void){

	int i;
	char* string=NULL;

	printf("StringArrayParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	for(i=0;i<this->numstrings;i++){
		string=this->value[i];
		printf("   %i: %s\n",i,string);
	}
}
/*}}}*/
/*FUNCTION StringArrayParam::Id{{{1*/
int    StringArrayParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringArrayParam::MyRank{{{1*/
int    StringArrayParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION StringArrayParam::Marshall{{{1*/
void  StringArrayParam::Marshall(char** pmarshalled_dataset){

	int   i;
	char* marshalled_dataset=NULL;
	int   enum_value=0;
	int   stringsize;
	char* string=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of StringArrayParam: */
	enum_value=StringArrayParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&numstrings,sizeof(numstrings));marshalled_dataset+=sizeof(numstrings);
	for(i=0;i<numstrings;i++){
		string=this->value[i];
		stringsize=strlen(string)+1;
		
		memcpy(marshalled_dataset,&stringsize,sizeof(stringsize));marshalled_dataset+=sizeof(stringsize);
		memcpy(marshalled_dataset,string,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);
	}

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION StringArrayParam::MarshallSize{{{1*/
int   StringArrayParam::MarshallSize(){

	int i;
	int marshallsize=0;
	int stringsize;
	char* string=NULL;

	marshallsize+=sizeof(numstrings);

	for(i=0;i<numstrings;i++){
		string=this->value[i];
		stringsize=strlen(string)+1;
		marshallsize+=sizeof(stringsize);
		marshallsize+=stringsize*sizeof(char);
	}
	
	marshallsize+=sizeof(enum_type);
	marshallsize+=sizeof(int); //sizeof(int) for enum value

	return marshallsize;
}
/*}}}*/
/*FUNCTION StringArrayParam::Demarshall{{{1*/
void  StringArrayParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;
	int   stringsize;
	char* string=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	memcpy(&numstrings,marshalled_dataset,sizeof(int));marshalled_dataset+=sizeof(int);
	if(numstrings){
		this->value=(char**)xmalloc(numstrings*sizeof(char*));

		for(i=0;i<numstrings;i++){
			memcpy(&stringsize,marshalled_dataset,sizeof(int));marshalled_dataset+=sizeof(int);

			string=(char*)xmalloc(stringsize*sizeof(char));
			memcpy(string,marshalled_dataset,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);

			this->value[i]=string;
		}
	}
	else this->value=NULL;

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION StringArrayParam::ObjectEnum{{{1*/
int StringArrayParam::ObjectEnum(void){

	return StringArrayParamEnum;

}
/*}}}*/
/*FUNCTION StringArrayParam::copy{{{1*/
Object* StringArrayParam::copy() {
	
	return new StringArrayParam(this->enum_type,this->value,this->numstrings);

}
/*}}}*/

/*StringArrayParam virtual functions definitions: */
/*FUNCTION StringArrayParam::GetParameterValue{{{1*/
void  StringArrayParam::GetParameterValue(char*** pstringarray,int* pM){
	
	int   i;
	char** outstrings=NULL;
	int   M;
	char* string=NULL;
	char* string2=NULL;
	int   stringsize;

	M=this->numstrings;
	if(this->numstrings){
		outstrings=(char**)xmalloc(this->numstrings*sizeof(char*));

		for(i=0;i<this->numstrings;i++){
			string=this->value[i];
			stringsize=strlen(string)+1;

			string2=(char*)xmalloc(stringsize*sizeof(char));
			memcpy(string2,string,stringsize*sizeof(char));

			outstrings[i]=string2;
		}
	}
	else outstrings=NULL;

	/*Assign output pointers:*/
	*pM=M;
	*pstringarray=outstrings;
}
/*}}}*/
/*FUNCTION StringArrayParam::GetParameterName{{{1*/
char* StringArrayParam::GetParameterName(void){
	return  EnumToStringx(this->enum_type);
}
/*}}}*/
/*FUNCTION StringArrayParam::SetMatlabField{{{1*/
#ifdef _SERIAL_
void  StringArrayParam::SetMatlabField(mxArray* dataref){
	
	int      i;
	char*    name=NULL;
	mwSize   dims[2]={0};
	mxArray* pfield=NULL;
	
	name=this->GetParameterName();

	dims[0]=this->numstrings;
	dims[1]=1;
	pfield=mxCreateCellArray(2,dims);
	for(i=0;i<this->numstrings;i++){
		char* string=value[i];
		mxSetCell(pfield,i,mxCreateString(string));
	}
	mxSetField( dataref, 0, name,pfield);
}
#endif
/*}}}*/
/*FUNCTION StringArrayParam::SetValue{{{1*/
void  StringArrayParam::SetValue(char** stringarray,int M){
	
	int   i;
	char *string     = NULL;
	char *string2    = NULL;
	int   stringsize;

	/*first, avoid leak: */
	for(i=0;i<this->numstrings;i++){
		string=this->value[i];
		xfree((void**)&string);
	}
	xfree((void**)&this->value);

	/*copy: */
	this->numstrings=M;
	this->value=(char**)xmalloc(this->numstrings*sizeof(char*));
	for(i=0;i<this->numstrings;i++){
		string=stringarray[i];
		stringsize=strlen(string)+1;

		string2=(char*)xmalloc(stringsize*sizeof(char));
		memcpy(string2,string,stringsize*sizeof(char));

		this->value[i]=string2;
	}
}
/*}}}*/
/*FUNCTION StringArrayParam::UnitConversion{{{1*/
void  StringArrayParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
