/*
 * \file Results.c
 * \brief: implementation of the Results class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Results::Results(){{{1*/
Results::Results(){
	return;
}
/*}}}*/
/*FUNCTION Results::Results(int in_enum){{{1*/
Results::Results(int in_enum): DataSet(in_enum) {
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Results::~Results(){{{1*/
Results::~Results(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Results::SpawnTriaResults{{{1*/
Results* Results::SpawnTriaResults(int* indices){

	/*Intermediary*/
	vector<Object*>::iterator object;
	ElementResult* resultin=NULL;
	ElementResult* resultout=NULL;

	/*Output*/
	Results* newresults=new Results();

	/*Go through results and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new result*/
		resultin=(ElementResult*)(*object); 
		resultout=resultin->SpawnTriaElementResult(indices);

		/*Add result to new results*/
		newresults->AddObject((Object*)resultout);
	}

	/*Assign output pointer*/
	return newresults;
}
/*}}}*/
/*FUNCTION Results::Write{{{1*/
#ifdef _SERIAL_
void Results::Write(mxArray** pdataref){

	int i,j;
	int count;

	/*output: */
	mxArray* dataref=NULL;
	mxArray* processeddataref=NULL;
	mwSize nfields;
	mwSize maxfields;
	mwSize nsteps;
	mwSize step;
	const char **fnames      = NULL;
	int         *enums       = NULL;
	int          baseenum;
	mwSize       onebyone[2] = {1,1};
	mwSize       ndim        = 2;

	/*How many time steps do we have? : */
	nsteps=0;
	for(i=0;i<this->Size();i++){
		ExternalResult* result=(ExternalResult*)this->GetObjectByOffset(i);
		step=result->GetStep();
		if(step>nsteps)nsteps=step;
	}
	onebyone[0]=nsteps;

	/*How many field names do we have. First, figure out how many result types we have: */
	maxfields=(mwSize)this->Size();
	enums=(int*)xmalloc(maxfields*sizeof(int));
	for(i=0;i<maxfields;i++){
		ExternalResult* result=(ExternalResult*)this->GetObjectByOffset(i);
		enums[i]=result->InstanceEnum();
	}
	/*Now, make result types unique: */
	for(i=0;i<maxfields;i++){
		if(enums[i]>=0){//if <0, it means this enum was found to replicate another one previously
			baseenum=enums[i]; 		
			/*is the baseenum repeated later on?:*/
			for(j=i+1;j<maxfields;j++){
				if (enums[j]==baseenum)enums[j]=-1;
			}
		}
		else continue;
	}

	/*Now, go through enums, and whatever is not null is a non repeated field name: */
	nfields=0;
	for(i=0;i<maxfields;i++)if(enums[i]>0)nfields++;

	/*Add 2 fields for time and step: */
	nfields=nfields+2;
	
	/*Fill the names of the structure field: */
	fnames=(const char**)xmalloc(nfields*sizeof(char*));
	count=0;
	for(i=0;i<maxfields;i++){
		if (enums[i]>0){
			fnames[count]=EnumToStringx(enums[i]);
			count++;
		}
	}
	/*don't forget the extra fields "time" and "step":*/
	fnames[nfields-2]="time";
	fnames[nfields-1]="step";

	/*Initialize structure: */
	dataref=mxCreateStructArray( ndim,onebyone,nfields,fnames);

	/*Fill each field: */
	for(i=0;i<nfields-2;i++){ //do not include the last one used for time
		ExternalResult* result=(ExternalResult*)this->GetObjectByOffset(i);
		result->SetMatlabField(dataref);
	}

	/*Now, process the patch in the dataref structure, by calling MatlabProcessPatch.m 
	 *on the current dataref structure: */
	mexCallMATLAB(1,&processeddataref,1,&dataref, "MatlabProcessPatch");

	/*Assign output pointers:*/
	*pdataref=processeddataref;
}
#else 
void Results::Write(Parameters* parameters){
	
	int         i;
	FILE       *fid          = NULL;
	bool        io_gather=true;

	/*Recover file descriptor: */
	parameters->FindParam(&fid,OutputFilePointerEnum);
	parameters->FindParam(&io_gather,SettingsIoGatherEnum);

	for(i=0;i<this->Size();i++){
		ExternalResult* result=(ExternalResult*)this->GetObjectByOffset(i);

		/*write result to disk: */
		result->WriteData(fid,io_gather);
	}

}
#endif
/*}}}*/
