/*!\file TriaVertexElementResult.c
 * \brief: implementation of the TriaVertexElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*TriaVertexElementResult constructors and destructor*/
/*FUNCTION TriaVertexElementResult::TriaVertexElementResult(){{{1*/
TriaVertexElementResult::TriaVertexElementResult(){
	return;
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::TriaVertexElementResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
TriaVertexElementResult::TriaVertexElementResult(int in_enum_type,double* in_values,int in_step, double in_time){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::~TriaVertexElementResult(){{{1*/
TriaVertexElementResult::~TriaVertexElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION TriaVertexElementResult::Echo {{{1*/
void TriaVertexElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::DeepEcho{{{1*/
void TriaVertexElementResult::DeepEcho(void){
		
	printf("TriaVertexElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   values: [%g %g %g]\n",this->values[0],this->values[1],this->values[2]);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::Id{{{1*/
int    TriaVertexElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION TriaVertexElementResult::MyRank{{{1*/
int    TriaVertexElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION TriaVertexElementResult::Marshall{{{1*/
void  TriaVertexElementResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;


	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of TriaVertexElementResult: */
	enum_value=TriaVertexElementResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall TriaVertexElementResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::MarshallSize{{{1*/
int   TriaVertexElementResult::MarshallSize(){
	
	return sizeof(values)
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::Demarshall{{{1*/
void  TriaVertexElementResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION TriaVertexElementResult::Enum{{{1*/
int TriaVertexElementResult::Enum(void){

	return TriaVertexElementResultEnum;

}
/*}}}*/
/*FUNCTION TriaVertexElementResult::copy{{{1*/
Object* TriaVertexElementResult::copy() {
	
	return new TriaVertexElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION TriaVertexElementResult::EnumType{{{1*/
int TriaVertexElementResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaVertexElementResult::SpawnTriaElementResult{{{1*/
ElementResult* TriaVertexElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaVertexElementResult* outresult=NULL;

	/*Create new Tria result (copy of current result)*/
	outresult=new TriaVertexElementResult(this->enum_type,&this->values[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION TriaVertexElementResult::ProcessUnits{{{1*/
void TriaVertexElementResult::ProcessUnits(Parameters* parameters){
	
	UnitConversion(this->values,3,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION TriaVertexElementResult::NumberOfNodalValues{{{1*/
int TriaVertexElementResult::NumberOfNodalValues(void){
	return 3;
}
/*}}}*/
/*FUNCTION TriaVertexElementResult::PatchFill{{{1*/
void TriaVertexElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,3);

}
/*}}}*/
/*FUNCTION TriaVertexElementResult::GetVectorFromResults{{{1*/
void TriaVertexElementResult::GetVectorFromResults(Vec vector,int* doflist,int numdofs){

	if(numdofs!=3)_error_("Result %s is a TriaVertexElementResult and cannot write vector of %i dofs",numdofs);
	VecSetValues(vector,numdofs,doflist,(const double*)this->values,INSERT_VALUES);

} /*}}}*/
