/*! \file PentaVertexElementResult.h 
 *  \brief: header file for penta vertex result  object. 
 *  this object is just a PentaVertexInput with additional time and step info.
 */


#ifndef _PENTAVERTEXELEMENTRESULT_H_
#define _PENTAVERTEXELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
/*}}}*/

class PentaVertexElementResult: public ElementResult{

	private: 
		int    enum_type;
		double values[6];
		int    step;
		double time;

	public:

		/*PentaVertexElementResult constructors, destructors: {{{1*/
		PentaVertexElementResult();
		PentaVertexElementResult(int enum_type,double* values,int step, double time);
		~PentaVertexElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   Enum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnTriaElementResult(int* indices);
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*PentaVertexElementResult management: {{{1*/
		int   EnumType();
		void GetVectorFromResults(Vec vector,int* doflist,int numdofs);
		/*}}}*/

};
#endif  /* _PENTAVERTEXELEMENTRESULT_H */
