%BALANCETHICKNESS class definition
%
%   Usage:
%      balancethickness=balancethickness();

classdef balancethickness
	properties (SetAccess=public) 
		spcthickness      = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		thickening_rate   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		stabilization     = modelfield('default',0,'marshall',true,'format','Integer');
	end
	methods
		function obj = balancethickness(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Type of stabilization used
			obj.stabilization=1;

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if solution~=BalancethicknessSolutionEnum, return; end

			checkfield(md,'balancethickness.spcthickness','forcing',1);
			checkfield(md,'balancethickness.thickening_rate','size',[md.mesh.numberofvertices 1],'NaN',1);
			checkfield(md,'balancethickness.stabilization','size',[1 1],'values',[0 1 3]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   balance thickness solution parameters:'));

			fielddisplay(obj,'spcthickness','thickness constraints (NaN means no constraint)');
			fielddisplay(obj,'thickening_rate','ice thickening rate used in the mass conservation (dh/dt)');
			fielddisplay(obj,'stabilization','0->no, 1->artificial_diffusivity, 3->discontinuous Galerkin');

		end % }}}
	end
end
