%SURFACEFORCING Class definition
%
%   Usage:
%      surfaceforcings=surfaceforcings();

classdef surfaceforcings
	properties (SetAccess=public) 
		accumulation_rate = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		ablation_rate     = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		mass_balance      = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = surfaceforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(PrognosticAnalysisEnum,analyses),
				fields={'mass_balance'};
				checkforcing(md,'surfaceforcings',fields);
			end
			if ismember(BalancethicknessAnalysisEnum,analyses),
				fields={'mass_balance'};
				checksize(md,'surfaceforcings',fields,[md.mesh.numberofvertices 1]);
				checknan(md, 'surfaceforcings',fields);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));

			fielddisplay(obj,'accumulation_rate','surface accumulation rate [m]');
			fielddisplay(obj,'ablation_rate','surface ablation rate [m]');
			fielddisplay(obj,'mass_balance','surface mass balance [m]');

		end % }}}
	end
end
