%BASAL FORCINGS class definition
%
%   Usage:
%      basalforcings=basalforcings();

classdef basalforcings
	properties (SetAccess=public) 
		melting_rate             = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		melting_rate_correction  = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		geothermalflux           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = basalforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			fields={'geothermalflux'};
			%checksize(md,'basalforcings',fields,[md.mesh.numberofvertices 1]);
			if ismember(PrognosticAnalysisEnum,analyses),
				fields={'melting_rate'};
				checkforcing(md,'basalforcings',fields);
			end
			if ismember(BalancethicknessAnalysisEnum,analyses),
				fields={'melting_rate'};
				checksize(md,'basalforcings',fields,[md.mesh.numberofvertices 1]);
				checknan(md, 'basalforcings',fields);
			end
			if ismember(ThermalAnalysisEnum,analyses),
				fields={'geothermalflux'};
				checksize(md,'basalforcings',fields,[md.mesh.numberofvertices 1]);
				checknan(md, 'basalforcings',fields);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   basal forcings parameters:'));

			fielddisplay(obj,'melting_rate','basal melting rate (positive if melting)');
			fielddisplay(obj,'melting_rate_correction','additional melting applied when the grounding line retreats');
			fielddisplay(obj,'geothermalflux','geothermal heat flux [W/m^2]');

		end % }}}
	end
end
