%INITIALIZATION class definition
%
%   Usage:
%      initialization=initialization();

classdef initialization
	properties (SetAccess=public) 
		vx            = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',VxEnum);
		vy            = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',VyEnum);
		vz            = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',VzEnum);
		vel           = modelfield('default',NaN,'marshall',false);
		pressure      = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',PressureEnum);
		temperature   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',TemperatureEnum);
		watercolumn   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',WatercolumnEnum);
		waterfraction = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',WaterfractionEnum);
	end
	methods
		function obj = initialization(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   initial field values:'));

			fielddisplay(obj,'vx','x component of velocity');
			fielddisplay(obj,'vy','y component of velocity');
			fielddisplay(obj,'vz','z component of velocity');
			fielddisplay(obj,'vel','velocity norm');
			fielddisplay(obj,'pressure','pressure field');
			fielddisplay(obj,'temperature','temperature in Kelvins');
			fielddisplay(obj,'watercolumn','thickness of subglacial water');
			fielddisplay(obj,'waterfraction','fraction of water in the ice');

		end % }}}
	end
end
