%CONSTANTS class definition
%
%   Usage:
%      groundingline=groundingline();

classdef groundingline
	properties (SetAccess=public) 
		migration    = modelfield('default','','marshall',true,'preprocess','StringToEnum','format','Integer');
		melting_rate = modelfield('default',NaN,'marshall',true,'format','Double');
	end
	methods
		function obj = groundingline(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Type of migration
			obj.migration='None';

			%basal melting rate correction: 
			obj.melting_rate=0; 


		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			if ~ismember({obj.migration},{'None' 'AgressiveMigration' 'SoftMigration'}),
				checkmessage(['groundingline.migration field should be ''None'' ''AgressiveMigration'' or ''SoftMigration''']);
			end
			if ~strcmp(obj.migration,'None'),
				if (md.mesh.dimension==3 | strcmpi(md.cluster.name,'none')),
					checkmessage(['requesting grounding line migration, but grounding line module only implemented for 2d models and parallel runs!']);
				end
				if isnan(md.geometry.bathymetry),
					checkmessage(['requesting grounding line migration, but bathymetry is absent!']);
				end
				pos=find(md.mask.vertexongroundedice); 
				if any(md.geometry.bed(pos)-md.geometry.bathymetry(pos)),
					checkmessage(['bathymetry not equal to bed on grounded ice !']);
				end
				pos=find(md.mask.vertexonfloatingice); 
				if any(md.geometry.bathymetry(pos)-md.geometry.bed(pos)>10^-9),
					checkmessage(['bathymetry superior to bed on floating ice !']);
				end
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   balance thickness solution parameters:'));

			fielddisplay(obj,'migration','type of grounding line migration: ''SoftMigration'',''AgressiveMigration'' or ''None''');
			fielddisplay(obj,'melting_rate','melting rate applied when previously grounded parts start floating');

		end % }}}
	end
end
