%AUTODIFF class definition
%
%   Usage:
%      autodiff=autodiff();

classdef autodiff
	properties (SetAccess=public) 
		analysis = modelfield('default',false,'marshall',true,'format','Boolean');
		forward = modelfield('default',true,'marshall',true,'format','Boolean');
		reverse = modelfield('default',false,'marshall',true,'format','Boolean');
	end
	methods
		function obj = autodiff(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   automatic differentiation parameters:'));

			fielddisplay(obj,'analysis','indicates if the automatic differentiation is activated');
			fielddisplay(obj,'forward','forward differentiation');
			fielddisplay(obj,'reverse','backward differentiation');

		end % }}}
	end
end
