function PETSC_VERSION=petscversion()
%PETSCVERSION - recover petsc version number, inside config.h file
%
%   Usage:
%       PETSC_VERSION=petscversion();


configfile=[issmtier() '/config.h'];
if ~exist(configfile,'file'),
	error(['File ' configfile ' not found. ISSM has not been configured yet!']);
end

%go through the file, and recover the line we want
fid=fopen(configfile,'r');
while(1),
	tline=fgets(fid);
	if ~ischar(tline), break, end
	if  strncmp(tline,'#define _PETSC_MAJOR_',21),
		PETSC_VERSION=str2num(tline(23));
	end
end
fclose(fid);
