#!/bin/sh

#External packages versions:
#petsc 3.1
#mpich 1.3.1

./configure \
 --prefix=$ISSM_TIER \
 --with-matlab-dir=$MATLAB_DIR \
 --with-triangle-dir=$ISSM_TIER/externalpackages/triangle/install \
 --with-metis-dir=$ISSM_TIER/externalpackages/metis/install \
 --with-petsc-dir=$ISSM_TIER/externalpackages/petsc/install \
 --with-petsc-version=3 \
 --with-tao-dir=$ISSM_TIER/externalpackages/tao/install \
 --with-mpi-include=$ISSM_TIER/externalpackages/mpich2/install/include  \
 --with-mpi-lib="-L$ISSM_TIER/externalpackages/mpich2/install/lib/ -lmpich " \
 --with-petsc-arch=$ISSM_ARCH \
 --with-dakota-dir=$ISSM_TIER/externalpackages/dakota/install \
 --with-blas-lapack-dir=$ISSM_TIER/externalpackages/petsc/install \
 --with-plapack-lib="-L $ISSM_TIER/externalpackages/petsc/install/ -lPLAPACK" \
 --with-plapack-include="-I $ISSM_TIER/externalpackages/petsc/install/externalpackages/PLAPACKR32-hg/INCLUDE" \
 --with-blacs-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-scalapack-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-mumps-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-scotch-dir="$ISSM_TIER/externalpackages/scotch/install" \
 --with-chaco-dir="$ISSM_TIER/externalpackages/chaco/install" \
 --with-fortran-lib="-L/usr/lib/gcc/x86_64-redhat-linux/4.1.1/ -lgfortran" \
 --with-graphics-lib=/usr/lib64/libX11.so \
 --with-cxxoptflags="-march=opteron -O2" \
 --with-numthreads=32 \
 --enable-debugging
