%RADAROVERLAY class definition
%
%   Usage:
%      radaroverlay=radaroverlay();

classdef radaroverlay
	properties (SetAccess=public) 
		pwr = modelfield('default',NaN,'marshall',false);
		x   = modelfield('default',NaN,'marshall',false);
		y   = modelfield('default',NaN,'marshall',false);
	end
	methods
		function obj = radaroverlay(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   radaroverlay parameters:'));

			fielddisplay(obj,'pwr','radar power image (matrix)');
			fielddisplay(obj,'x','corresponding x coordinates');
			fielddisplay(obj,'y','corresponding y coordinates');

		end % }}}
	end
end
