%FLOWEQUATION class definition
%
%   Usage:
%      flowequation=flowequation();

classdef flowequation
	properties (SetAccess=public) 
		ismacayealpattyn     = modelfield('default',0,'marshall',true,'format','Boolean');
		ishutter             = modelfield('default',0,'marshall',true,'format','Boolean');
		isstokes             = modelfield('default',0,'marshall',true,'format','Boolean');
		vertex_equation      = modelfield('default',NaN,'marshall',true,'preprocess','marshallapproximations','format','DoubleMat','mattype',1);
		element_equation     = modelfield('default',NaN,'marshall',true,'preprocess','marshallapproximations','format','DoubleMat','mattype',2);
		bordermacayeal       = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		borderpattyn         = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		borderstokes         = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = flowequation(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function checkconsistency(obj,md) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   flow equation parameters:'));

			fielddisplay(obj,'ismacayealpattyn','is the macayeal or pattyn approximation used ?');
			fielddisplay(obj,'ishutter','is the shallow ice approximation used ?');
			fielddisplay(obj,'isstokes','are the Full-Stokes equations used ?');
			fielddisplay(obj,'vertex_equation','flow equation for each vertex');
			fielddisplay(obj,'element_equation','flow equation for each element');
			fielddisplay(obj,'bordermacayeal','vertices on MacAyeal''s border (for tiling)');
			fielddisplay(obj,'borderpattyn','vertices on Pattyn''s border (for tiling)');
			fielddisplay(obj,'borderstokes','vertices on Stokes'' border (for tiling)');

		end % }}}
	end
end
