/*!\file Icefront.h
 * \brief: header file for icefront object
 */

#ifndef _ICEFRONT_H_
#define _ICEFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class Matpar;
class Node;
class Element;
class IoModel;
class ElementVector;
/*}}}*/

class Icefront: public Load {

	public:
		int id;
		int analysis_type;

		/*hooks: */
		Hook* hnodes;
		Hook* helement;
		Hook* hmatpar;

		/*Corresponding fields*/
		Matpar   *matpar;
		Node    **nodes;
		Element  *element;

		/*inputs and parameters: */
		Inputs* inputs;
		Parameters* parameters;

		/*Icefront constructors, destructors: {{{1*/
		Icefront();
		Icefront(int icefront_id,int i, IoModel* iomodel,int in_icefront_type, int analysis_type);
		~Icefront();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented yet");};
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kff, Mat Kfs);
		void  CreatePVector(Vec pf);
		void  PenaltyCreateKMatrix(Mat Kff, Mat kfs, double kmax);
		void  PenaltyCreatePVector(Vec pf, double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Load management: {{{1*/
		void  GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void GetSegmentNormal(double* normal,double xyz_list[2][3]);
		void GetQuadNormal(double* normal,double xyz_list[4][3]);
		#ifdef _HAVE_CONTROL_
		ElementVector* CreatePVectorAdjointHoriz(void);
		#endif
		#ifdef _HAVE_DIAGNOSTIC_
		ElementVector* CreatePVectorDiagnosticHoriz(void);
		ElementVector* CreatePVectorDiagnosticMacAyeal2d(void);
		#endif
        #ifdef _HAVE_THREED_
		ElementVector* CreatePVectorDiagnosticMacAyeal3d(void);
		ElementVector* CreatePVectorDiagnosticPattyn(void);
		ElementVector* CreatePVectorDiagnosticStokes(void);
	    #endif
		/*}}}*/
};

#endif  /* _ICEFRONT_H_ */
