/*!\file Segment.c
 * \brief: implementation of the Segment object
 */

/*Include files: {{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "./objects.h"
#include "../Container/Container.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/include.h"
/*}}}*/

/*Segment constructors and destructors:*/
/*FUNCTION Segment::Segment() default constructor {{{1*/
Segment::Segment(){
	this->eid=UNDEF;
	this->x1=UNDEF;
	this->y1=UNDEF;
	this->x2=UNDEF;
	this->y2=UNDEF;
}
/*}}}*/
/*FUNCTION Segment::Segment(int eid, double x1,double y1,double x2, double y2){{{1*/
Segment::Segment(int segment_eid, double segment_x1,double segment_y1,double segment_x2, double segment_y2){

	this->eid=segment_eid;
	this->x1=segment_x1;
	this->y1=segment_y1;
	this->x2=segment_x2;
	this->y2=segment_y2;

}
/*}}}*/
/*FUNCTION Segment::~Segment(){{{1*/
Segment::~Segment(){
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION Segment::Echo{{{1*/
void Segment::Echo(void){

	printf("Segment:\n");
	printf("   eid: %i\n",eid);
	printf("   node 1: %g|%g\n",this->x1,this->y1);
	printf("   node 2: %g|%g\n",this->x2,this->y2);

}
/*}}}*/
/*FUNCTION Segment::DeepEcho{{{1*/
void Segment::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Segment::Id{{{1*/
int    Segment::Id(void){ return eid; }
/*}}}*/
/*FUNCTION Segment::MyRank{{{1*/
int    Segment::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION Segment::Marshall{{{1*/
void  Segment::Marshall(char** pmarshalled_dataset){

	_error_(" not supported yet!");
}
/*}}}*/
/*FUNCTION Segment::MarshallSize{{{1*/
int   Segment::MarshallSize(){
	_error_(" not supported yet!");
}
/*}}}*/
/*FUNCTION Segment::Demarshall{{{1*/
void  Segment::Demarshall(char** pmarshalled_dataset){
	_error_(" not supported yet!");
}
/*}}}*/
#endif
/*FUNCTION Segment::Enum{{{1*/
int Segment::Enum(void){

	return SegmentEnum;

}
/*}}}*/
/*FUNCTION Segment::copy {{{1*/
Object* Segment::copy() {
	return new Segment(this->eid,this->x1,this->y1,this->x2,this->y2);

}

/*}}}*/
