/*!\file Riftfront.h
 * \brief: header file for riftfront object
 */

#ifndef _RIFTFRONT_H_
#define _RIFTFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;
/*}}}*/

class Riftfront: public Load {

	public:
		int		id;
		int     analysis_type;

		/*hooks: */
		Hook* hnodes;
		Hook* helements;
		Hook* hmatpar;
		
		/*Corresponding fields*/
		Matpar   *matpar;
		Node    **nodes;
		Element **elements;

		/*computational: */
		int      penalty_lock;
		bool     active;
		bool     frozen;
		int      counter;
		bool     prestable;
		bool     material_converged;
		double   normal[2];
		double   length;
		double   fraction;
		int      state;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;


		/*Riftfrontconstructors,destructors: {{{1*/
		Riftfront();
		Riftfront(int riftfront_id,int i, IoModel* iomodel,int analysis_type);
		~Riftfront();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void    InputUpdateFromVector(double* vector, int name, int type);
		void    InputUpdateFromVector(int* vector, int name, int type){_error_("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){_error_("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(double* vector, int name, int type){_error_("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(int* vector, int name, int type){_error_("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(bool* vector, int name, int type){_error_("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name);
		void    InputUpdateFromConstant(int constant, int name);
		void    InputUpdateFromConstant(bool constant, int name){_error_("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){_error_("Not implemented yet!");}
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented yet");};
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kff, Mat Kfs);
		void  CreatePVector(Vec pf);
		void  PenaltyCreateKMatrix(Mat Kff, Mat kfs, double kmax);
		void  PenaltyCreatePVector(Vec pf, double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Riftfront specific routines: {{{1*/
		bool  PreStable();
		ElementMatrix* PenaltyCreateKMatrixDiagnosticHoriz(double kmax);
		ElementVector* PenaltyCreatePVectorDiagnosticHoriz(double kmax);
		void  SetPreStable();
		int   PreConstrain(int* punstable);
		int   Constrain(int* punstable);
		void  FreezeConstraints(void);
		bool  IsFrozen(void);
		int   Penetration(double* ppenetration);
		int   MaxPenetration(double* ppenetration);
		int   PotentialUnstableConstraint(int* punstable);
		int   IsMaterialStable(void);
		bool  IsInput(int name);
		/*}}}*/
};

#endif  /* _RIFTFRONT_H_ */
