/*! \file TransientInput.h 
 *  \brief: header file for transientinput object
 */


#ifndef _TRANSIENTINPUT_H_
#define _TRANSIENTINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
class GaussTria;
class Parameters;
/*}}}*/

class TransientInput: public Input{

	public:
		int     enum_type;
		int     numtimesteps;
		Inputs* inputs;
		double* timesteps;
		Parameters* parameters; //to find current time.

		/*TransientInput constructors, destructors: {{{1*/
		TransientInput();
		TransientInput(int enum_type);
		~TransientInput();
		void AddTimeInput(Input* input,double time);
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		int   Id();
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   Enum();
		Object* copy();
		/*}}}*/
		/*TransientInput management: {{{1*/
		int    EnumType();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* forcingB){_error_("not implemented yet");};
		Input* PointwiseMin(Input* forcingB){_error_("not implemented yet");};
		Input* PointwiseMax(Input* forcingB){_error_("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue){_error_("not implemented yet");};
		void GetParameterValue(int* pvalue){_error_("not implemented yet");};
		void GetParameterValue(double* pvalue){_error_("not implemented yet");};
		void GetParameterValue(double* pvalue,GaussTria* gauss);
		void GetParameterValue(double* pvalue,GaussPenta* gauss){_error_("not implemented yet");};
		void GetParameterValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetParameterValue(double* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetParameterAverage(double* pvalue);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum){_error_("not implemented yet");};
		void Scale(double scale_factor){_error_("not implemented yet");};
		void ArtificialNoise(double min,double max){_error_("not implemented yet");};
		void AXPY(Input* xforcing,double scalar){_error_("not implemented yet");};
		void Constrain(double cm_min, double cm_max){_error_("not implemented yet");};
		double InfinityNorm(void);
		double Max(void);
		double MaxAbs(void);
		double Min(void);
		double MinAbs(void);
		void Extrude(void){_error_("not supported yet");}
		void VerticallyIntegrate(Input* thickness_forcing){_error_("not supported yet");};
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values){_error_("not supported yet");};
      void GetTimeValues(double* values,double time){_error_("not implemented yet");};
		Input* GetTimeInput(double time);
		/*}}}*/

};
#endif  /* _TRANSIENTINPUT_H */
