/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"

class DataSet;
class Parameters;
class Patch;

#include "../../toolkits/toolkits.h"
/*}}}*/

class Element: public Object,public Update{

	public: 
		
		virtual        ~Element(){};
	
		virtual void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   CreateKMatrix(Mat Kff, Mat Kfs,Vec df)=0;
		virtual void   CreatePVector(Vec pf)=0;
		virtual void   GetSolutionFromInputs(Vec solution)=0;
		virtual int    GetNodeIndex(Node* node)=0;
		virtual int    Sid()=0;
		virtual bool   IsOnShelf()=0; 
		virtual bool   IsNodeOnShelf()=0; 
		virtual bool   IsNodeOnShelfFromFlags(double* flags)=0; 
		virtual bool   IsOnBed()=0;
		virtual void   GetParameterListOnVertices(double* pvalue,int enumtype)=0;
		virtual void   GetParameterListOnVertices(double* pvalue,int enumtype,double defaultvalue)=0;
		virtual void   GetParameterValue(double* pvalue,Node* node,int enumtype)=0;
		#ifdef _HAVE_CONTROL_
		virtual void   Gradj(Vec gradient,int control_type)=0;
		virtual double ThicknessAbsMisfit(bool process_units  ,int weight_index)=0;
		virtual double SurfaceAbsVelMisfit(bool process_units ,int weight_index)=0;
		virtual double SurfaceRelVelMisfit(bool process_units ,int weight_index)=0;
		virtual double SurfaceLogVelMisfit(bool process_units ,int weight_index)=0;
		virtual double SurfaceLogVxVyMisfit(bool process_units,int weight_index)=0;
		virtual double SurfaceAverageVelMisfit(bool process_units,int weight_index)=0;
		virtual double ThicknessAbsGradient(bool process_units,int weight_index)=0;
		virtual double RheologyBbarAbsGradient(bool process_units,int weight_index)=0;
		virtual double DragCoefficientAbsGradient(bool process_units,int weight_index)=0;
		virtual void   ControlInputGetGradient(Vec gradient,int enum_type)=0;
		virtual void   ControlInputSetGradient(double* gradient,int enum_type)=0;
		virtual void   ControlInputScaleGradient(int enum_type, double scale)=0;
		virtual void   InputControlUpdate(double scalar,bool save_parameter)=0;
		#endif
		virtual double SurfaceArea(void)=0;
		virtual void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum)=0;
		virtual void   ComputeBasalStress(Vec sigma_b)=0;
		virtual void   ComputeStrainRate(Vec eps)=0;
		virtual double MassFlux(double* segment,bool process_units)=0;
		virtual void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes)=0;
		virtual void   PatchFill(int* pcount, Patch* patch)=0;
		virtual void   DeleteResults(void)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void   InputToResult(int enum_type,int step,double time)=0;
		virtual void   InputDuplicate(int original_enum,int new_enum)=0;
		virtual void   InputCreate(double scalar,int name,int code)=0;
		virtual void   InputCreate(double* vector, int index,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code)=0;
		virtual void   ProcessResultsUnits(void)=0;
		virtual void   RequestedOutput(int output_enum,int step,double time)=0;
		virtual void   MinVel(double* pminvel, bool process_units)=0;
		virtual void   MaxVel(double* pmaxvel, bool process_units)=0;
		virtual void   MinVx(double* pminvx, bool process_units)=0;
		virtual void   MaxVx(double* pmaxvx, bool process_units)=0;
		virtual void   MaxAbsVx(double* pmaxabsvx, bool process_units)=0;
		virtual void   MinVy(double* pminvy, bool process_units)=0;
		virtual void   MaxVy(double* pmaxvy, bool process_units)=0;
		virtual void   MaxAbsVy(double* pmaxabsvy, bool process_units)=0;
		virtual void   MinVz(double* pminvz, bool process_units)=0;
		virtual void   MaxVz(double* pmaxvz, bool process_units)=0;
		virtual void   MaxAbsVz(double* pmaxabsvz, bool process_units)=0;
		virtual void   InputScale(int enum_type,double scale_factor)=0;
		virtual void   GetVectorFromInputs(Vec vector,int NameEnum)=0;
		virtual void   InputArtificialNoise(int enum_type,double min,double max)=0;
		virtual bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums)=0;
		virtual void   AverageOntoPartition(Vec partition_contributions,Vec partition_areas,double* vertex_response,double* qmu_part)=0;
		virtual int*   GetHorizontalNeighboorSids(void)=0;
		virtual double TimeAdapt()=0;
		virtual void   AgressiveMigration()=0;
		virtual void   SoftMigration(double* sheet_ungrounding)=0;
		virtual void   ShelfSync()=0;
		virtual void   PotentialSheetUngrounding(Vec potential_sheet_ungrounding)=0;
		virtual void   MigrateGroundingLine()=0;
		virtual int    UpdateShelfStatus(Vec new_shelf_nodes)=0;
		virtual void   UpdateShelfFlags(double* new_shelf_nodes)=0;
		virtual int    UpdatePotentialSheetUngrounding(double* potential_sheet_ungrounding,Vec vec_nodes_on_iceshelf,double* nodes_on_iceshelf)=0;
		virtual double RheologyBbarx(void)=0;
		virtual int    NodalValue(double* pvalue, int index, int natureofdataenum,bool process_units)=0;

		/*Implementation: */

};
#endif
