%BASAL FORCINGS class definition
%
%   Usage:
%      basalforcings=basalforcings();

classdef basalforcings
	properties (SetAccess=public) 
		melting_rate             = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		melting_rate_correction  = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		geothermalflux           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = basalforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function checkconsistency(obj,md) % {{{

			%fields={'melting_rate','geothermalflux'};
			checksize(md,'basalforcings',fields,[md.mesh.numberofvertices 1]);
		end % }}}
	end
end
