/*!\file: bedslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void bedslope_core(FemModel* femmodel){

	/*parameters: */
	int  dim;
	bool isstokes;
	bool ishutter;
	bool control_analysis;
	int  solution_type;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&dim,MeshDimensionEnum);
	femmodel->parameters->FindParam(&control_analysis,InversionIscontrolEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	_printf_(VerboseSolution(),"%s\n","   computing slope");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(BedSlopeAnalysisEnum,BedSlopeXAnalysisEnum);
	solver_linear(femmodel);
	femmodel->SetCurrentConfiguration(BedSlopeAnalysisEnum,BedSlopeYAnalysisEnum);
	solver_linear(femmodel);
	
	if(solution_type==BedSlopeSolutionEnum && !control_analysis){
		_printf_(VerboseSolution(),"   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeXEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeYEnum);
	}

}
