%STEADYSTATE class definition
%
%   Usage:
%      steadystate=steadystate();

classdef steadystate
	properties (SetAccess=public) 
		reltol            = modelfield('default',0,'marshall',true,'format','Double');
		maxiter           = modelfield('default',0,'marshall',true,'format','Integer');
		requested_outputs = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
	end
	methods
		function obj = steadystate(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%maximum of steady state iterations
			obj.maxiter=100;

			%Relative tolerance for the steadystate convertgence
			obj.reltol=0.01;
		end % }}}
		function checkconsistency(obj,md) % {{{

			%Early return
			if md.private.solution~=SteadystateSolutionEnum, return; end;

			if md.timestepping.time_step~=0,
				checkmessage(['model not consistent: for a steadystate computation, timestepping.time_step must be zero.']);
			end

			if isnan(md.diagnostic.reltol),
				checkmessage(['model not consistent: for a steadystate computation, diagnostic.reltol (relative convergence criterion) must be defined!']);
			end
		end % }}}
	end
end
