%TRANSIENT class definition
%
%   Usage:
%      transient=transient();

classdef transient
	properties (SetAccess=public) 
		isprognostic      = modelfield('default',0,'marshall',true,'format','Boolean');
		isdiagnostic      = modelfield('default',0,'marshall',true,'format','Boolean');
		isthermal         = modelfield('default',0,'marshall',true,'format','Boolean');
		isgroundingline   = modelfield('default',0,'marshall',true,'format','Boolean');
		requested_outputs = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
	end
	methods
		function obj = transient(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%full analysis: Diagnostic, Prognostic and Thermal but no groundingline migration for now
			obj.isprognostic=1;
			obj.isdiagnostic=1;
			obj.isthermal=1;
			obj.isgroundingline=0;

		end % }}}
		function disp(obj) % {{{
			disp('Transient parameters on a pure solution basis:');
			fielddisplay(obj,'isprognostic','indicates if a prognostic solution is used in the transient');
			fielddisplay(obj,'isthermal','indicates if a thermal solution is used in the transient');
			fielddisplay(obj,'isdiagnostic','indicates if a diagnostic solution is used in the transient');
			fielddisplay(obj,'isgroundingline','indicates if a groundingline migration is used in the transient');

		end % }}}
		function checkconsistency(obj,md) % {{{
			if ~ismember(md.transient.isdiagnostic,[0 1]),
				checkmessage('model not consistent: transient.isdiagnostic should be a scalar (1 or 0)');
			end
			if ~ismember(md.transient.isprognostic,[0 1]),
				checkmessage('model not consistent: transient.isprognostic should be a scalar (1 or 0)');
			end
			if ~ismember(md.transient.isthermal,[0 1]),
				checkmessage('model not consistent: transient.isthermal should be a scalar (1 or 0)');
			end
			if ~ismember(md.transient.isgroundingline,[0 1]),
				checkmessage('model not consistent: transient.isgroundingline should be a scalar (1 or 0)');
			end

		end % }}}
	end
end
