%RIFTS class definition
%
%   Usage:
%      rifts=rifts();

classdef rifts
	properties (SetAccess=public) 
		riftstruct     = modelfield('default',NaN,'marshall',true,'preprocess','marshallrifts','format','DoubleMat','mattype',3);
		riftproperties = modelfield('default',NaN,'marshall',false);
		numrifts       = modelfield('default',0,'marshall',true,'format','Integer');
	end
	methods
		function obj = rifts(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end
		end % }}}
		function checkconsistency(obj,md) % {{{
			if obj.numrifts,
				if ~(md.mesh.dimension==2),
					checkmessage(['model not consistent: models with rifts are only supported in 2d for now!']);
				end
				if ~isstruct(obj.riftstruct),
					checkmessage(['rifts.riftstruct should be a structure!']);
				end
				if ~isempty(find(md.mesh.segmentmarkers>=2)),
					%We have segments with rift markers, but no rift structure!
					checkmessage(['model should be processed for rifts (run meshprocessrifts)!']);
				end
				%Check that rifts are filled with proper material
				checkvalues(md,{'rifts.riftstruct.fill'},[WaterEnum() AirEnum() IceEnum() MelangeEnum()]);
			else
				if ~isnans(obj.riftstruct),
					checkmessage(['riftstruct shoud be NaN since obj.numrifts is 0!']);
				end
			end
		end % }}}
	end
end
