%FRICTION class definition
%
%   Usage:
%      friction=friction();

classdef friction
	properties (SetAccess=public) 
		coefficient = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		p           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',2);
		q           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',2);
	end
	methods
		function obj = friction(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function checkconsistency(obj,md) % {{{

		end % }}}
		function disp(obj) % {{{

			disp(sprintf('Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_ice*g*bed, r=q/p and s=1/p'));
			fielddisplay(obj,'coefficient','friction coefficient [IS]');
			fielddisplay(obj,'p','p exponent');
			fielddisplay(obj,'q','q exponent');
		end % }}}
	end
end
