function ismodelselfconsistent(md),
%ISMODELSELFCONSISTENT - check that model forms a closed form solvable problem.
%
%   Usage:
%      ismodelselfconsistent(md),

%initialize consistency as true
modelconsistency(true);

%Go through al model field check that it is a class and call checkconsistency
fields=properties(md);
for i=1:length(fields),
	field=fields{i};
	if ismember(field,{'cluster' 'results' 'debug' 'radaroverlay'}),
		continue;
	end
	if ~isobject(md.(field))
		checkmessage(['field ''' char(field) ''' is not an object']);
	else
		md.(field).checkconsistency(md);
	end
end

%error message if mode is not consistent
if modelconsistency==false,
	error(' ');
end
