%THERMAL class definition
%
%   Usage:
%      thermal=thermal();

classdef thermal
	properties (SetAccess=public) 
		spctemperature    = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		penalty_threshold = modelfield('default',0,'marshall',true,'format','Integer');
		stabilization     = modelfield('default',0,'marshall',true,'format','Integer');
		maxiter           = modelfield('default',0,'marshall',true,'format','Integer');
		penalty_lock      = modelfield('default',0,'marshall',true,'format','Integer');
		penalty_factor    = modelfield('default',0,'marshall',true,'format','Double');
	end
	methods
		function obj = thermal(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%Number of unstable constraints acceptable
			obj.penalty_threshold=0;

			%Type of stabilization used
			obj.stabilization=1;

			%Maximum number of iterations
			obj.maxiter=100;

			%factor used to compute the values of the penalties: kappa=max(stiffness matrix)*10^penalty_factor
			obj.penalty_factor=3;
		end % }}}
		function checkconsistency(obj,md) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Thermal solution parameters:'));

			disp(sprintf('\n      parameters:'));
			fielddisplay(obj,'penalty_lock','stabilize unstable thermal constraints that keep zigzagging after n iteration (default is 0, no stabilization)');
			fielddisplay(obj,'penalty_threshold','threshold to declare convergence of thermal solution (default is 0)');

			disp(sprintf('\n      boundary conditions:'));
			fielddisplay(obj,'spctemperature','constraints flag list (first column) and values (second column)');

		end % }}}
	end
end
