%SETTINGS class definition
%
%   Usage:
%      settings=settings();

classdef settings
	properties (SetAccess=public) 
		io_gather           = modelfield('default',0,'marshall',true,'format','Boolean');
		lowmem              = modelfield('default',0,'marshall',true,'format','Boolean');
		results_on_vertices = modelfield('default',0,'marshall',true,'format','Boolean');
		output_frequency    = modelfield('default',0,'marshall',true,'format','Integer');
		waitonlock          = modelfield('default',0,'marshall',true,'format','Boolean');
	end
	methods
		function obj = settings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%are we short in memory ? (0 faster but requires more memory)
			obj.lowmem=0;

			%i/o:
			obj.io_gather=1;

			%results frequency by default every step
			obj.output_frequency=1;

			%this option can be activated to load automatically the results
			%onto the model after a parallel run by waiting for the lock file
			%N minutes that is generated once the solution has converged
			%0 to desactivate
			md.waitonlock=Inf;
		end % }}}
		function checkconsistency(obj,md) % {{{

		end % }}}
	end
end
