%FLAIM class definition
%
%   Usage:
%      flaim=flaim();

classdef flaim
	properties (SetAccess=public) 
		tracks             = modelfield('default','','marshall',false);
		flightreqs         = modelfield('default',struct(),'marshall',false);
		criterion          = modelfield('default',NaN,'marshall',false);
		gridsatequator     = modelfield('default',200000,'marshall',false);
		usevalueordering   = modelfield('default',true,'marshall',false);
		split_antimeridian = modelfield('default',true,'marshall',false);
		solution           = modelfield('default','','marshall',false);
		quality            = modelfield('default',0,'marshall',false);
	end
	methods
		function obj = flaim(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function checkconsistency(obj,md) % {{{

			if md.private.solution~=FlaimSolutionEnum,
				return;
			end

			if ~exist(obj.tracks,'file')
				checkmessage(['flaim.tracks file ''' md.flaim.tracks ''' does not exist.']);
			end
			%   probably going to need some checks on flaim.flightreqs here
			if (numel(obj.criterion)~=md.mesh.numberofvertices) & (numel(obj.criterion)~=md.mesh.numberofelements),
				checkmessage(['flaim.criterion vector must have number of nodes (' ...
					int2str(md.mesh.numberofvertices) ') or elements (' int2str(md.mesh.numberofelements)...
					') values, not ' int2str(numel(md.flaim.criterion)) ' values.']);
			end

		end % }}}
		function disp(obj) % {{{

			disp(sprintf('   FLAIM - Flight Line Adaptation using Ice sheet Modeling:')); 

			disp(sprintf('\n      Input:'));
			fielddisplay(obj,'tracks'             ,'name of kml tracks file');
			fielddisplay(obj,'flightreqs'         ,'structure of kml flight requirements');
			fielddisplay(obj,'criterion'          ,'element or nodal criterion for flight path evaluation');

			disp(sprintf('\n      Arguments:'));
			fielddisplay(obj,'gridsatequator'     ,'number of grids at equator (determines resolution)');
			fielddisplay(obj,'usevalueordering'   ,'flag to consider target values for flight path evaluation');
			fielddisplay(obj,'split_antimeridian' ,'flag to split polygons on the antimeridian');

			disp(sprintf('\n      Output:'));
			fielddisplay(obj,'solution'           ,'name of kml solution file');
			fielddisplay(obj,'quality'            ,'quality of kml solution');
		end % }}}
	end
end
