function md=reorder(md)
%REORDER - reorder nodes and elements of a model
%
%   Usage: 
%      md=reorder(md)

%some checks
if md.mesh.dimension==3,
	error('reorder error message: 3d models not supported yet, exiting...')
end
disp('reorder warning: only the mesh fields are reorder. The model needs to be reparameterized');

%reorder elements
newelements=randperm(md.mesh.numberofelements)';
tnewelements=zeros(md.mesh.numberofelements,1);tnewelements(newelements)=[1:md.mesh.numberofelements]';

%reorder nodes
newnodes=randperm(md.mesh.numberofvertices)';
tnewnodes=zeros(md.mesh.numberofvertices,1);tnewnodes(newnodes)=[1:md.mesh.numberofvertices]';

%update all fields
md.mesh.elements=tnewnodes(md.mesh.elements(newelements,:));
md.mesh.segments=[tnewnodes(md.mesh.segments(:,1)) tnewnodes(md.mesh.segments(:,2)) tnewelements(md.mesh.segments(:,3))];
md.mesh.x=md.mesh.x(newnodes);
md.mesh.y=md.mesh.y(newnodes);
md.mesh.z=md.mesh.z(newnodes);
md.mesh.vertexonboundary=zeros(md.mesh.numberofvertices,1); md.mesh.vertexonboundary(md.mesh.segments(:,1:2))=1;
