%MESH class definition
%
%   Usage:
%      mesh=mesh();

classdef mesh
	properties (SetAccess=public) 
		average_vertex_connectivity = modelfield('default',0,'marshall',true,'format','Integer');
		extractedvertices           = modelfield('default',NaN,'marshall',false);
		extractedelements           = modelfield('default',NaN,'marshall',false);
		vertexonboundary            = modelfield('default',NaN,'marshall',false);
		lat        = modelfield('default',NaN,'marshall',false);
		long       = modelfield('default',NaN,'marshall',false);
		hemisphere = modelfield('default',NaN,'marshall',false);
		segments            = modelfield('default',NaN,'marshall',false);
		segmentmarkers      = modelfield('default',NaN,'marshall',false);
		dimension           = modelfield('default',0,'marshall',true,'format','Integer');
		numberofelements    = modelfield('default',0,'marshall',true,'format','Integer');
		numberofvertices    = modelfield('default',0,'marshall',true,'format','Integer');
		numberofedges       = modelfield('default',0,'marshall',true,'format','Integer');
		numberoflayers      = modelfield('default',0,'marshall',true,'format','Integer');
		numberofvertices2d    = modelfield('default',0,'marshall',true,'format','Integer');
		numberofelements2d = modelfield('default',0,'marshall',true,'format','Integer');
		vertexconnectivity    = modelfield('default',NaN,'marshall',false);
		elementconnectivity = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
		uppervertex           = modelfield('default',NaN,'marshall',false);
		upperelements        = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',2);
		lowerelements        = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',2);
		lowervertex           = modelfield('default',NaN,'marshall',false);
		elementonbed      = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',2);
		elementonsurface  = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',2);
		vertexonbed         = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',1);
		vertexonsurface     = modelfield('default',NaN,'marshall',true,'format','BooleanMat','mattype',1);
		elements2d         = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
		x2d                = modelfield('default',NaN,'marshall',false);
		y2d                = modelfield('default',NaN,'marshall',false);
		elements            = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',2);
		edges               = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',3);
		x                   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		y                   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
		z                   = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = mesh(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%the connectivity is the avergaded number of nodes linked to a
			%given node through an edge. This connectivity is used to initially
			%allocate memory to the stiffness matrix. A value of 16 seems to
			%give a good memory/time ration. This value can be checked in
			%trunk/test/Miscellaneous/runme.m
			obj.average_vertex_connectivity=25;
		end % }}}
		function checkconsistency(obj,md) % {{{

			fields={'dimension'};
			checkgreaterstrict(md,'mesh',fields,0);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Mesh:')); 

			if obj.dimension==3,
				disp(sprintf('\n      Elements and vertices of the original 2d mesh:'));
				fielddisplay(obj,'numberofelements2d','number of elements');
				fielddisplay(obj,'numberofverticess2d','number of vertices');
				fielddisplay(obj,'elements2d','index into (x,y,z), coordinates of the vertices');
				fielddisplay(obj,'x2d','vertices x coordinate');
				fielddisplay(obj,'y2d','vertices y coordinate');

				disp(sprintf('\n      Elements and vertices of the extruded 3d mesh:'));
			else
				disp(sprintf('\n      Elements and vertices:'));
			end
			fielddisplay(obj,'numberofelements','number of elements');
			fielddisplay(obj,'numberofvertices','number of vertices');
			fielddisplay(obj,'elements','index into (x,y,z), coordinates of the vertices');
			fielddisplay(obj,'elements_type','element types');
			fielddisplay(obj,'x','vertices x coordinate');
			fielddisplay(obj,'y','vertices y coordinate');
			fielddisplay(obj,'z','vertices z coordinate');
			fielddisplay(obj,'edges','edges of the 2d mesh (vertex1 vertex2 element1 element2)');

			disp(sprintf('\n      Properties:'));
			fielddisplay(obj,'dimension','mesh dimension (2d or 3d)');
			fielddisplay(obj,'numlayers','number of extrusion layers');
			fielddisplay(obj,'penalties','penalties list');
			fielddisplay(obj,'vertexonbed','lower vertices flags list');
			fielddisplay(obj,'elementonbed','lower elements flags list');
			fielddisplay(obj,'vertexonsurface','upper vertices flags list');
			fielddisplay(obj,'elementonsurface','upper elements flags list');
		end % }}}
	end
end
