function md=planettrimesh(md,shape,radius,refinement)
%PLANETTRIMESH: build 2d shell mesh
%
% Usage: md=planettrimesh(md,shape,radius,refinement)
%

results = sphere_tri(shape,refinement,radius);
md.x=results.vertices(:,1);
md.y=results.vertices(:,2);
md.z=results.vertices(:,3);
md.mesh.elements=results.faces;

md.r=sqrt(md.x.^2+md.y.^2+md.z.^2);
md.theta=acos(md.z./md.r);
md.phi=atan2(md.y,md.x);

md.mesh.numberofvertices=length(md.x);
md.mesh.numberofelements=size(md.mesh.elements,1);

md.mesh.dimension=3;
