function ismodelselfconsistent(md),
%ISMODELSELFCONSISTENT - check that model forms a closed form solvable problem.
%
%   Usage:
%      ismodelselfconsistent(md),

%initialize consistency as true
modelconsistency(true);

%General consistency checks
md.mesh.checkconsistency(md);

%Solution dependent checks
%FLAIM {{{1
switch(md.private.solution),
	case FlaimSolutionEnum, md.flaim.checkconsistency(md);
end
%}}}

%error message if mode is not consistent
if modelconsistency==false,
	error(' ');
end
