%CONSTANTS class definition
%
%   Usage:
%      constants=constants();

classdef constants
	properties (SetAccess=public) 
		g                    = modelfield('default',0,'marshall',true,'format','Double');
		yts                  = modelfield('default',0,'marshall',true,'format','Double');
		referencetemperature = modelfield('default',0,'marshall',true,'format','Double');
	end
	methods
		function obj = constants(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%acceleration due to gravity (m/s^2)
			obj.g=9.81;

			%converstion from year to seconds
			obj.yts=365*24*3600;

			%the reference temperature for enthalpy model (cf Aschwanden)
			obj.referencetemperature=223.15;

		end % }}}
		function flag = checkconsistency(obj,md) % {{{

		end % }}}
	end
end
