function flag=modelconsistency(flag_in)
%MODELCONSISTENCY - return flag for model consistency
%
%   Used to check model consistency
%
%   Usage:
%      flag=modelconsistency(flag_in)

persistent consistency;

if nargin==1 & nargout==0,
	%OK model is inconsistent, set flag as false
	consistency=flag_in;
elseif nargin==0 & nargout==1,
	if isempty(consistency),
		%modelinconsistent has never been called, model is consistent
		consistency=true;
	end
else
	message('Bad usage');
end

flag=consistency;
