function checkforcing(md,obj,fields)
%CHECKFORCING - checkforcing
%
%   Used to check model consistency
%
%   Usage:
%      checkforcing(md,obj,fields);

for i=1:length(fields),
	eval(['field=md.' obj '.' fields{i} ';']);
	if size(field,1)==md.mesh.numberofvertices,
		if ~size(field,2)==1,
			checkmessage(['model not consistent: field ''' obj '.' fields{i} ''' should have only one column as there are md.mesh.numberofvertices lines']);
		end
	elseif size(field,1)==md.mesh.numberofvertices+1
		if any(field(end,:)~=sort(field(end,:))),
			checkmessage(['model not consistent: field ''' obj '.' fields{i} ''' columns should be chronological']);
		end
		if any(field(end,1:end-1)==field(end,2:end)),
			checkmessage(['model not consistent: field ''' obj '.' fields{i} ''' columns must not contain duplicate timesteps']);
		end
	else
		checkmessage(['model not consistent: field ''' obj '.' fields{i} ''' should have md.mesh.numberofvertices or md.mesh.numberofvertices+1 lines']);
	end
end
