function md=meshrefine(md,areas)
%MESHREFINE:  refined the mesh from a model, according to an area metric.
%
%   Usage:
%      md=meshrefine(md,metric)

%some checks on list of arguments
if ((nargin~=2) | (nargout~=1)),
	meshrefineusage();
	error('meshrefine error message');
end
if ( (isempty(areas)) |  (length(areas)~=md.mesh.numberofelements) | (length(find(isnan(areas))))),
	meshrefineusage();
	error('meshrefine error message');
end

%Refine using TriMeshRefine
[md.elements,md.x,md.y,md.mesh.segments,md.mesh.segmentmarkers]=TriMeshRefine(md.elements,md.x,md.y,md.mesh.segments,md.mesh.segmentmarkers,areas,'yes');

%Fill in rest of fields:
md.mesh.numberofelements=length(md.elements);
md.mesh.numberofvertices=length(md.x);
md.z=zeros(md.mesh.numberofvertices,1);
md.mesh.vertexonboundary=zeros(md.mesh.numberofvertices,1); md.mesh.vertexonboundary(md.mesh.segments(:,1:2))=1;
md.mesh.vertexonbed=ones(md.mesh.numberofvertices,1);
md.mesh.vertexonsurface=ones(md.mesh.numberofvertices,1);
md.mesh.elementonbed=ones(md.mesh.numberofelements,1);
md.mesh.elementonsurface=ones(md.mesh.numberofelements,1);

%Now, build the connectivity tables for this mesh.
md.mesh.vertexconnectivity=NodeConnectivity(md.elements,md.mesh.numberofvertices);
md.mesh.elementconnectivity=ElementConnectivity(md.elements,md.mesh.vertexconnectivity);

%type of model
md.mesh.dimension=2;
end

function meshrefineusage(),
disp('usage: md=meshrefine(md,areas)');
end
