function displayparameters(md)
%DISPLAYPARAMETERS - display parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays parameters from model md, 
%   only if requested.
%
%   Usage:
%      displayparameters(md)

disp(sprintf('   Parameters:'));

disp(sprintf('\n      geometrical parameters:'));
fielddisplay(md,'surface','surface height [m]');
fielddisplay(md,'thickness','thickness [m]');
fielddisplay(md,'bed','bed height [m]');
fielddisplay(md,'bathymetry','bathymetry elevation (with respect to sea level) [m]');
fielddisplay(md,'firn_layer','firn layer height [m]');
fielddisplay(md,'mesh.elementonbed','element on bed flags list');
fielddisplay(md,'mesh.elementonsurface','element on surface flags list');
fielddisplay(md,'mesh.vertexonbed','node on bed flags list');
fielddisplay(md,'mesh.vertexonsurface','node on surface flags list');

disp(sprintf('\n      physical parameters:'));
fielddisplay(md,'g','acceleration due to gravity [m/s^2]');


