/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int i;
	bool   continuous_galerkin=true;
	int    numberofvertices;
	bool   isstokes,ismacayealpattyn;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Fetch parameters: */
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);
	iomodel->Constant(&isstokes,FlowequationIsstokesEnum);
	iomodel->Constant(&ismacayealpattyn,FlowequationIsmacayealpattynEnum);

	/*Recover pointer: */
	nodes=*pnodes;

	/*First create nodes*/
	if(!nodes) nodes = new Nodes(NodesEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayealpattyn & !isstokes){
		*pnodes=nodes;
		return;
	}

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*Create nodes: */
	iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
	
	for (i=0;i<numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		}
	}

	/*Clean fetched data: */
	iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
