function maxtime=cfl_step(md,vx,vy);
%CFL_STEP - return the maximum time step for the model in years
%
%   Dt < c / ( u/Dx +v/Dy )
%
%   Usage:
%      maxtime=cfl_step(md,vx,vy);
%
%   Example:
%      dt=cfl_step(md,md.results.diagnostic.vx,md.results.diagnostic.vy);

%Check length of velocities 
if size(vx,1)~=md.mesh.numberofvertices & size(vy,1)~=md.mesh.numberofvertices,
	error('timestpes error message: size of velocity components must be the same as md.mesh.numberofvertices');
end

index=md.elements;
edgex=max(md.x(index),[],2)-min(md.x(index),[],2);
edgey=max(md.y(index),[],2)-min(md.y(index),[],2);
vx=max(abs(vx(index)),[],2);
vy=max(abs(vy(index)),[],2);

maxtime=1/2*min(1./(vx./edgex+vy./edgey));
