function femmodel=adjointdiagnostic_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state
%
%   Usage:
%      femmodel=adjointdiagnostic_core(femmodel)

	%recover parameters common to all solutions
	isstokes=femmodel.parameters.FlowequationIsstokes;
	dim=femmodel.parameters.MeshDimension;
	control_analysis=femmodel.parameters.InversionIscontrol;
	solution_type=femmodel.parameters.SolutionType;
	conserve_loads=true;

	%set analysis type to compute velocity:
	issmprintf(VerboseSolution,'   computing velocities');
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
	femmodel=solver_nonlinear(femmodel,conserve_loads);

	%Call SurfaceAreax, because some it might be needed by PVector
	femmodel.elements=SurfaceArea(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

	%compute adjoint
	issmprintf(VerboseSolution,'   computing adjoint');
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	femmodel=solver_adjoint_linear(femmodel);

	%save results
	if(solution_type==AdjointSolutionEnum & ~control_analysis)
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointyEnum);
		if(isstokes),
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointzEnum);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointpEnum);
		end
	end
