function projection_value=project2d(md3d,value,layer)
%PROJECT2D - returns the value of a field for a given layer of the mesh
%
%   project 'value' vector taken at layer 'layer' from extruded 2d-3d mesh onto 2d mesh 
%   used to do the extrusion. This routine is used to compare values between a 2d-3d mesh
%   at a certain layer, and the equivalent value (if it exists), on the original 2d mesh. 
%   This routine relies heavily on projections (contained in 3d model md) recored during 
%   the extrude operation.
%
%   Usage:
%      projection_value=project2d(md3d,value,layer)
%
%   Example:
%      vel2=project2d(md3d,md3d.vel,2);

%some checks on list of arguments
if ((nargin~=3) ),
	help project2d
	error('project2d error message');
end

if (md3d.mesh.dimension~=3),
	error('wrong model type ... should be ''3d''');
end

if ((layer<1) | (layer>md3d.mesh.numberoflayers)),
	error(['layer must be between 1 and ' num2str(md3d.numlayers)]);
end

if size(value,1)==md3d.mesh.numberofnodes,
	projection_value=value((layer-1)*md3d.mesh.numberofvertices2d+1:layer*md3d.mesh.numberofvertices2d,:);
elseif size(value,1)==md3d.mesh.numberofnodes+1,
	projection_value=[value((layer-1)*md3d.mesh.numberofvertices2d+1:layer*md3d.mesh.numberofvertices2d,:); value(end,:)];
else
	projection_value=value((layer-1)*md3d.mesh.numberofelements2d+1:layer*md3d.mesh.numberofelements2d,:);
end
