/*!\file:  CorePointerFromSolutionEnum.cpp
 * \brief: return type of analyses, number of analyses and core solution function.
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void CorePointerFromSolutionEnum(void (**psolutioncore)(FemModel*),Parameters* parameters,int solutiontype){

	/*intermediary: */
	bool control_analysis=false;
	bool dakota_analysis=false;
	
	/*output: */
	void (*solutioncore)(FemModel*)=NULL;

	/*retrieve some parameters: */
	parameters->FindParam(&control_analysis,InversionIscontrolEnum);
	parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);

	switch(solutiontype){
	
		case DiagnosticSolutionEnum:
			solutioncore=&diagnostic_core;
			break;
		case SteadystateSolutionEnum:
			solutioncore=&steadystate_core;
			break;
		case ThermalSolutionEnum:
			solutioncore=&thermal_core;
			break;
		case EnthalpySolutionEnum:
			solutioncore=&enthalpy_core;
			break;
		case PrognosticSolutionEnum:
			solutioncore=&prognostic_core;
			break;
		case BalancethicknessSolutionEnum:
			solutioncore=&balancethickness_core;
			break;
		case SurfaceSlopeSolutionEnum:
			solutioncore=&surfaceslope_core;
			break;
		case BedSlopeSolutionEnum:
			solutioncore=&bedslope_core;
			break;
		case TransientSolutionEnum:
			solutioncore=&transient_core;
			break;
		case GroundinglineMigration2dSolutionEnum:
			solutioncore=&groundinglinemigration2d_core;
			break;
		case HydrologySolutionEnum:
			solutioncore=&hydrology_core;
			break;
		default:
			_error_("%s%s%s"," solution type: ",EnumToStringx(solutiontype)," not supported yet!");
			break;
	}
	
	/*Assign output pointer:*/
	_assert_(psolutioncore);
	*psolutioncore=solutioncore;

}
