/*! \file CreateLoadsBalancethickness.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsBalancethickness(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int element;
	int stabilization;
	int numberofedges;

	/*Fetch parameters: */
	iomodel->Constant(&stabilization,BalancethicknessStabilizationEnum);
	iomodel->Constant(&numberofedges,MeshNumberofedgesEnum);

	/*Output*/
	Loads*    loads    = NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);
	
	/*Loads only in DG*/
	if (stabilization==3){

		/*Get edges and elements*/
		iomodel->FetchData(3,EdgesEnum,ElementsEnum,ThicknessEnum);

		/*First load data:*/
		for (i=0;i<numberofedges;i++){

			/*Get left and right elements*/
			element=(int)iomodel->Data(EdgesEnum)[4*i+2]-1; //edges are [node1 node2 elem1 elem2]

			/*Now, if this element is not in the partition, pass: */
			if(!iomodel->my_elements[element]) continue;

			/* Add load */
			loads->AddObject(new Numericalflux(iomodel->loadcounter+i+1,i,iomodel,BalancethicknessAnalysisEnum));
		}

		/*Free data: */
		iomodel->DeleteData(3,EdgesEnum,ElementsEnum,ThicknessEnum);
	}

	/*Assign output pointer: */
	*ploads=loads;
}
