md=setmesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,4,1);
md=setflowequation(md,'pattyn','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution(1).Temperature),...
	PatchToVec(md.results.ThermalSolution(1).BasalforcingsMeltingRate),...
	};
