function J=misfit(md)
%MISFIT - compute misfit
%
%   Usage:
%      J=misfit(md)
%
%   Example:
%      J=misfit(md)
%

if md.mesh.dimension==2,
	elements=md.elements;
	x=md.x;
	y=md.y;
	vx=md.initialization.vx;
	vy=md.initialization.vy;
	vx_obs=md.inversion.vx_obs;
	vy_obs=md.inversion.vy_obs;
else
	elements=md.elements2d;
	x=md.x2d;
	y=md.y2d;
	vx=project2d(md,md.initialization.vx,md.numlayers);
	vy=project2d(md,md.initialization.vy,md.numlayers);
	vx_obs=project2d(md,md.inversion.vx_obs,md.numlayers);
	vy_obs=project2d(md,md.inversion.vy_obs,md.numlayers);
end

%compute areas;
areas=GetAreas(elements,x,y);

%compute delta v on elements
deltav=1/2*(   (vx-vx_obs).^2+(vy-vy_obs).^2)/md.constants.yts^2;
deltav_elem=deltav(elements)*[1;1;1]/3;

%compute misfit
J=sum(deltav_elem.*areas);
