function displaymesh(md)
%DISPLAYMESH - display mesh information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays mesh information from model md, 
%   only if requested.
%
%   Usage:
%      displaymesh(md)

disp(sprintf('   Mesh:')); 

if md.mesh.dimension==3,

	disp(sprintf('\n      Elements and nodes of the original 2d mesh:'));
	fielddisplay(md,'numberofelements2d','number of elements');
	fielddisplay(md,'numberofnodes2d','number of nodes');
	fielddisplay(md,'elements2d','index into (x,y,z), coordinates of the nodes');
	fielddisplay(md,'x2d','nodes x coordinate');
	fielddisplay(md,'y2d','nodes y coordinate');

	disp(sprintf('\n      Elements and nodes of the extruded 3d mesh:'));
else
	disp(sprintf('\n      Elements and nodes:'));
end
fielddisplay(md,'numberofelements','number of elements');
fielddisplay(md,'numberofnodes','number of nodes');
fielddisplay(md,'elements','index into (x,y,z), coordinates of the nodes');
fielddisplay(md,'elements_type','element types');
fielddisplay(md,'x','nodes x coordinate');
fielddisplay(md,'y','nodes y coordinate');
fielddisplay(md,'z','nodes z coordinate');
fielddisplay(md,'edges','edges of the 2d mesh (node1 node2 element1 element2)');

disp(sprintf('\n      Properties:'));
fielddisplay(md,'dim','mesh dimension (2d or 3d)');
fielddisplay(md,'numlayers','number of extrusion layers');
fielddisplay(md,'bamg','Geometry and 2d mesh properties (if generated by Bamg)');
fielddisplay(md,'penalties','penalties list');
fielddisplay(md,'nodeonbed','lower nodes flags list');
fielddisplay(md,'elementonbed','lower elements flags list');
fielddisplay(md,'nodeonsurface','upper nodes flags list');
fielddisplay(md,'elementonsurface','upper elements flags list');
