function [bx,by,b]=bedslope(md)
%BEDSLOPE - compute the bed slope
%
%   Usage:
%      [bx,by,s]=bedslope(md)

%load some variables (it is much faster if the variab;es are loaded from md once for all) 
if (md.mesh.dimension==2),
	numberofelements=md.numberofelements;
	numberofnodes=md.numberofnodes;
	index=md.elements;
	x=md.x; y=md.y;
else
	numberofelements=md.numberofelements2d;
	numberofnodes=md.numberofnodes2d;
	index=md.elements2d;
	x=md.x2d; y=md.y2d;
end

%compute nodal functions coefficients N(x,y)=alpha x + beta y + gamma
[alpha beta]=GetNodalFunctionsCoeff(index,x,y);

summation=[1;1;1];
bx=(md.geometry.bed(index).*alpha)*summation;
by=(md.geometry.bed(index).*beta)*summation;
b=sqrt(bx.^2+by.^2);

if md.mesh.dimension==3,
	bx=project3d(md,bx,'element');
	by=project3d(md,by,'element');
	b=sqrt(bx.^2+by.^2);
end
